/** @file   particlesparks.h
 * @brief   Declaration of ParticleSparks - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_PARTICLESPARKS_H
#define H_ENG2D_PARTICLESPARKS_H

#include "eng2d_dll.h"
#include "particlesystem.h"

namespace eng2d {

/** @class  ParticleSparks
 * @brief   Creates a spark-effect.
 * @author  Tomi Lamminsaari
 *
 */
class DLLIMPORT ParticleSparks : public ParticleSystem
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  static int s_averageLifetime;

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	ParticleSparks( const Vec2D& rP, const Vec2D& rD, int num );


	/** Destructor
   */
	virtual ~ParticleSparks();

private:
  ParticleSparks( const ParticleSparks& rO );
  ParticleSparks& operator = ( const ParticleSparks& rO );
public:

};

};  // end of namespace

#endif
